/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.utils.log;

import java.util.logging.Level;
import java.util.logging.Logger;
import net.skinsrestorer.api.interfaces.ISRConsole;
import net.skinsrestorer.shared.interfaces.ISRLogger;
import net.skinsrestorer.shared.utils.log.SRLogLevel;

public class JavaLoggerImpl
implements ISRLogger {
    private final ISRConsole console;
    private Logger logger;

    @Override
    public void log(SRLogLevel level, String message) {
        switch (level) {
            case INFO: {
                if (this.console.isReady()) {
                    this.console.sendMessage(message);
                    break;
                }
                this.logger.info(message);
                break;
            }
            case WARNING: {
                this.logger.warning(message);
                break;
            }
            case SEVERE: {
                this.logger.severe(message);
                break;
            }
        }
    }

    @Override
    public void log(SRLogLevel level, String message, Throwable throwable) {
        switch (level) {
            case INFO: {
                this.logger.log(Level.INFO, message, throwable);
                break;
            }
            case WARNING: {
                this.logger.log(Level.WARNING, message, throwable);
                break;
            }
            case SEVERE: {
                this.logger.log(Level.SEVERE, message, throwable);
                break;
            }
        }
    }

    public JavaLoggerImpl(ISRConsole console, Logger logger) {
        this.console = console;
        this.logger = logger;
    }

    public ISRConsole getConsole() {
        return this.console;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }
}

